% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_zone.R
\name{compare_zone}
\alias{compare_zone}
\title{Compare spatial zone means}
\usage{
compare_zone(
  data,
  variable,
  zonesCol,
  alpha = 0.05,
  join = sf::st_nearest_feature,
  returnLSD = FALSE,
  grid_dim
)
}
\arguments{
\item{data}{\code{sf} object with zones}

\item{variable}{\code{character} or \code{sf} object to use for mean comparison}

\item{zonesCol}{\code{character} colname from data were zone are specified}

\item{alpha}{\code{numeric} Significance level to use for comparison}

\item{join}{function to use for st_join if variable is \code{sf} object}

\item{returnLSD}{\code{logical} when LSD calculates with spatial variance should be returned}

\item{grid_dim}{\code{numeric} grid dimentins to estimate spatial variance}
}
\value{
\code{list} with differences and descriptive_stat
}
\description{
Compare spatial zone means
}
\examples{
library(sf)
data(wheat, package = "paar")

##Convert to an sf object
wheat <- sf::st_as_sf(wheat,
                      coords = c("x", "y"),
                      crs = 32720)
clusters <- paar::kmspc(
  wheat,
  variables = c('CE30', 'CE90', 'Elev', 'Pe', 'Tg'),
  number_cluster = 3:4
)
data_clusters <- cbind(wheat, clusters$cluster)
compare_zone(data_clusters,
             "Elev",
             "Cluster_3")
}
\references{
Paccioretti, P., Córdoba, M., & Balzarini, M. (2020).
FastMapping: Software to create field maps and identify management zones
in precision agriculture. Computers and Electronics in Agriculture, 175,
105556 https://doi.org/10.1016/j.compag.2020.105556.
}
