% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib_diff.R
\name{distrib_diff_gmm}
\alias{distrib_diff_gmm}
\title{Compute the dissimilarity for a Gaussian mixture model and identify
the lowest density observation.}
\usage{
distrib_diff_gmm(x, z, prop, mu, sigma, logdet)
}
\arguments{
\item{x}{Data.}

\item{z}{Component assignment probability matrix.}

\item{prop}{Vector of component proportions.}

\item{mu}{List of component mean vectors.}

\item{sigma}{List of component covariance matrices.}

\item{logdet}{Vector of log-determinants for covariance matrices.}
}
\value{
\code{distrib_diff_gmm} returns a list with the following elements:
\describe{
\item{\code{distrib_diff}}{Aggregated dissimilarity across components.}
\item{\code{distrib_diff_vec}}{Vector containing dissimilarity value for each
component.}
\item{\code{choice_id}}{Index of observation with lowest mixture density.}
\item{\code{removal_dens}}{Value of the lowest mixture density.}
}
}
\description{
At each iteration of \link{ombc_gmm}, \code{distrib_diff_gmm} computes the
dissimilarity value of the current Gaussian mixture model. It also
identifies the observation with the lowest mixture density.
}
