% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrack.R
\name{backtrack_gmm}
\alias{backtrack_gmm}
\title{Fit a Gaussian mixture model to the backtrack solution.}
\usage{
backtrack_gmm(
  x,
  ombc_out,
  max_total_rise = 0.1,
  max_step_rise = 0.05,
  init_model = NULL,
  init_z = NULL,
  manual_outlier_num = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{Data.}

\item{ombc_out}{An \code{"outliermbc_gmm"} or \code{"outliermbc_lcwm"} object, i.e. an
output from \code{ombc_gmm} or \code{ombc_lcwm}.}

\item{max_total_rise}{Upper limit for the cumulative increase, as a
proportion of the global minimum dissimilarity, from
all backward steps.}

\item{max_step_rise}{Upper limit for the increase, as a proportion of the
global minimum dissimilarity, from each backward step.}

\item{init_model}{Initial mixture model (\code{mixture::gpcm} \code{best_model}).}

\item{init_z}{Initial component assignment probability matrix.}

\item{manual_outlier_num}{User-specified number of outliers.}

\item{verbose}{Whether the iteration count is printed.}
}
\value{
\code{backtrack_gmm} returns a list with the following elements:
\describe{
\item{\code{labels}}{Vector of mixture component labels with outliers denoted by
0.}
\item{\code{outlier_bool}}{Logical vector indicating if an observation has been
classified as an outlier.}
\item{\code{outlier_num}}{Number of observations classified as outliers.}
\item{\code{mix}}{Output from mixture::gpcm fitted to the non-outlier
observations.}
\item{\code{call}}{Arguments / parameter values used in this function call.}
}
}
\description{
The \link{backtrack} function determines the number of outliers for the backtrack
solution and \link{plot_backtrack} plots this on a dissimilarity curve.
\code{backtrack_gmm} fits the mixture model corresponding to the number of
outliers selected by the backtrack solution (or any manually specified number
of outliers).
}
\examples{
ombc_gmm_k3n1000o10 <- ombc_gmm(
  gmm_k3n1000o10[, 1:2],
  comp_num = 3, max_out = 20
)

backtrack_gmm(gmm_k3n1000o10[, 1:2], ombc_gmm_k3n1000o10)
}
