% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_asymmetry.R
\encoding{UTF-8}
\name{ordinal_asymmetry}
\alias{ordinal_asymmetry}
\title{Computes the estimated asymmetry of an ordinal time series}
\usage{
ordinal_asymmetry(series, states, distance = "Block", normalize = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{normalize}{Logical. If \code{normalize = FALSE} (default), the value of the estimated asymmetry is returned. Otherwise, the function
returns the normalized estimated asymmetry.}
}
\value{
The estimated asymmetry.
}
\description{
\code{ordinal_asymmetry} computes the estimated asymmetry
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated asymmetry given by \eqn{\widehat{asym}_{d}=\widehat{\boldsymbol p}^\top (\boldsymbol J-\boldsymbol I)\boldsymbol D\widehat{\boldsymbol p}},
where \eqn{\widehat{\boldsymbol p}=(\widehat{p}_0, \widehat{p}_1, \ldots, \widehat{p}_n)^\top},
with \eqn{\widehat{p}_k} being the standard estimate of the marginal probability for state
\eqn{s_k}, \eqn{\boldsymbol I} and \eqn{\boldsymbol J} are the identity and counteridentity
matrices of order \eqn{n + 1}, respectively, and \eqn{\boldsymbol D} is a pairwise distance
matrix for the elements in the set \eqn{\mathcal{S}} considering a specific distance
between ordinal states, \eqn{d(\cdot, \cdot)}. If \code{normalize = TRUE}, then the normalized estimate is computed, namely
\eqn{\frac{\widehat{asym}_{d}}{max_{s_i, s_j \in \mathcal{S}}d(s_i, s_j)}}.
}
\examples{
estimated_asymmetry <- ordinal_asymmetry(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the asymmetry estimate
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
