% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_marginal_probabilities.R
\encoding{UTF-8}
\name{c_marginal_probabilities}
\alias{c_marginal_probabilities}
\title{Computes the cumulative marginal probabilities of an ordinal time series}
\usage{
c_marginal_probabilities(series, states)
}
\arguments{
\item{series}{An OTS (numerical vector with integers).}

\item{states}{A numerical vector containing the corresponding
states.}
}
\value{
A vector with the cumulative marginal probabilities.
}
\description{
\code{c_marginal_probabilities} returns a vector with the cumulative marginal
probabilities of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
vector \eqn{\widehat{\boldsymbol f} =(\widehat{f}_0, \ldots, \widehat{f}_n)},
with \eqn{\widehat{f}_i=\frac{N_i}{T}}, where \eqn{N_i} is the number
of elements less than or equal to \eqn{s_i} in the realization \eqn{\overline{X}_t}.
}
\examples{
vector_cmp <- c_marginal_probabilities(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the vector of
# cumulative marginal probabilities for one series in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
