% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binTest.R
\name{binWDTest}
\alias{binWDTest}
\title{Two-sample test for multivariate data based on binning.}
\usage{
binWDTest(x, y, L = 5, B = 100)
}
\arguments{
\item{x, y}{The two samples, rows are realizations.}

\item{L}{Number of bins in each dimension.}

\item{B}{Number of realizations of limiting distribution to simulate.}
}
\value{
p-value.
}
\description{
Two-sample test for multivariate data based on binning.
}
\examples{
\dontrun{
x <- MASS::mvrnorm(n = 100, mean = c(0, 0), Sigma = diag(1, 2))
y <- MASS::mvrnorm(n = 100, mean = c(0, 0), Sigma = diag(2, 2))
pVal <- binWDTest(x, y)}
}

