% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngd_api.R
\name{list_ngd_collections}
\alias{list_ngd_collections}
\title{Retrieve OS NGD Feature Collections}
\usage{
list_ngd_collections(simple = TRUE)
}
\arguments{
\item{simple}{(logical) Should only the collection ID be returned? Default is
\code{TRUE}. Use \code{FALSE} to return the detailed output.}
}
\value{
If \code{simple} is \code{TRUE} then return a character vector of
available collections identified by their shortened code, else return a
\code{data.frame} with the full details.
}
\description{
Query the osdatahub NGD Features API to gather information on available data
collections. An API key is not required for this query.
}
\details{
OS NGD themes and collections have been created to group similar
geographic entities and data types, making it quicker and easier to
identify the data you need. The OGC API - Features standard also references
feature collections, and in the context of OS NGD datasets, this is
equivalent to feature types. The following naming convention has been
applied to the feature collections: theme-collection-featuretype. Short
codes have been used for both the theme and collection to keep the feature
collection names manageable and not overly long. An example of the short
codes used is: 'bld-fts-buildingline'. For more information, see
\url{https://osdatahub.os.uk/docs/ofa/technicalSpecification}.
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ngd_collections <- list_ngd_collections(simple = TRUE)
ngd_collections[1:10]
\dontshow{\}) # examplesIf}
}
