% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{geom_to_bng}
\alias{geom_to_bng}
\alias{geom_to_bng_intersection}
\alias{geom_to_bng.geos_geometry}
\alias{geom_to_bng.sf}
\alias{geom_to_bng.sfc}
\alias{geom_to_bng_intersection.geos_geometry}
\alias{geom_to_bng_intersection.sf}
\alias{geom_to_bng_intersection.sfc}
\title{Spatial index for geometries}
\usage{
geom_to_bng(geom, resolution, ...)

\method{geom_to_bng}{geos_geometry}(geom, resolution, ...)

\method{geom_to_bng}{sf}(geom, resolution, ...)

\method{geom_to_bng}{sfc}(geom, resolution, ...)

geom_to_bng_intersection(
  geom,
  resolution,
  format = c("geos", "sf", "wkt"),
  ...
)

\method{geom_to_bng_intersection}{geos_geometry}(
  geom,
  resolution,
  format = c("geos", "sf", "wkt"),
  ...
)

\method{geom_to_bng_intersection}{sf}(
  geom,
  resolution,
  format = c("geos", "sf", "wkt"),
  ...
)

\method{geom_to_bng_intersection}{sfc}(
  geom,
  resolution,
  format = c("geos", "sf", "wkt"),
  ...
)
}
\arguments{
\item{geom}{geometry object of type \code{geos-geometry} or \code{sf}}

\item{resolution}{spatial resolution of the BNG cell expressed in string or
integer values}

\item{...}{additional parameters. Not currently used.}

\item{format}{character indicating the type of geometry object to return.
Default is "geos" while "sf" returns a geometry object of class \code{sfc}.}
}
\value{
\code{geom_to_bng}: list of vectors of \code{BNGReference} objects where the
number of items in the list equal \code{length(geom)}.

\code{geom_to_bng_intersection}: list of nested lists with
\code{length(geom)}. Each nested list contains three named items:
\itemize{
\item "BNGReference" - \code{BNGReference} objects representing the grid
squares corresponding to the decomposition.
\item "is_core" - logical vector indicating whether the grid square geometry
is entirely contained by the input geometry. This is relevant for Polygon
geometries and helps distinguish between "core" (fully inside) and "edge"
(partially overlapping) grid squares.
\item "geom" - The geometry representing the intersection between the input
geometry and the grid square. This can one of a number of geometry types
depending on the overlap. When "is_core" is \code{TRUE}, "geom" is the same
as the grid square geometry.
}
}
\description{
Returns a set of BNG Reference objects given a geometry and a specified
resolution.
}
\details{
The BNG Reference objects returned represent the grid squares intersected by
the input geometry. BNG Reference objects are de-duplicated in cases where
two or more parts of a multi-part geometry intersect the same grid square.

Unlike \code{geom_to_bng} which only returns BNG Reference objects
representing the grid squares intersected by the input geometry,
\code{geom_to_bng_intersection} returns list objects that store the
intersection between the input geometry and the grid square geometries.

These functions are useful for spatial indexing and aggregation of geometries
against the BNG. For geometry decomposition by the BNG index system, use
\code{geom_to_bng_intersection instead}.
}
\examples{
geom_to_bng(geos::geos_make_point(430000, 110000), "100km")

geom_to_bng(geos::geos_make_linestring(c(430000, 430010, 430010), c(110000,
110000, 110010)), "5m")

geom_to_bng_intersection(geos::geos_make_point(430000, 110000), "100km")

geom_to_bng_intersection(geos::geos_make_linestring(c(430000, 430010,
430010), c(110000, 110000, 110010)), "5m")

geom_to_bng_intersection(geos::geos_make_polygon(c(375480.64511692,
426949.67604058, 465166.20199588, 453762.88376729, 393510.2158297,
375480.64511692), c(144999.23691181, 160255.02751493, 153320.57724078,
94454.79935802, 91989.21703833, 144999.23691181)), "50km")

}
\seealso{
\code{\link[=geom_to_bng_intersection_explode]{geom_to_bng_intersection_explode()}}
}
