% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{deviance.ocm}
\alias{deviance.ocm}
\title{Extract the deviance from a fitted Continuous Ordinal Model}
\usage{
\method{deviance}{ocm}(object, ...)
}
\arguments{
\item{object}{\code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
The value of the deviance extracted from \code{object}.
}
\description{
Extracts the absolute conditional deviance for a fitted \code{ocm} object
}
\details{
The deviance is computed as:
\deqn{-2\ell}
where \eqn{\ell} is the conditional penalized log-likelihood.
}
\examples{
\dontrun{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
deviance(fit.overall)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
