% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builder.R
\name{populate_edges}
\alias{populate_edges}
\title{Populates the edges of a graph from a \code{data.frame}}
\usage{
populate_edges(graph_builder, edges_df, parent_col, child_col)
}
\arguments{
\item{graph_builder}{A graph builder object}

\item{edges_df}{A \code{data.frame} with a parent and child variable}

\item{parent_col}{The name of the column containing the parents}

\item{child_col}{The name of the column containing the children}
}
\value{
The updated graph builder object
}
\description{
Adds a set of edges from a \code{data.frame} to a graph
}
\examples{
graph_edges <- data.frame(
  parent = c("A", "B", "C"),
  child = c("B", "C", "D")
)

graph_builder() |>
  populate_edges(
    edges_df = graph_edges,
    parent_col = "parent",
    child_col = "child"
  )
}
\seealso{
Other build graphs: 
\code{\link{add_edge}()},
\code{\link{add_path}()},
\code{\link{build_acyclic}()},
\code{\link{build_directed}()},
\code{\link{graph_builder}()}
}
\concept{build graphs}
