% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_path.R
\name{find_path_one_to_many}
\alias{find_path_one_to_many}
\title{Find the a valid path from one node to many}
\usage{
find_path_one_to_many(graph, from, to)
}
\arguments{
\item{graph}{A graph object}

\item{from}{The starting node of the path}

\item{to}{A character vector of nodes}
}
\value{
A list of paths
}
\description{
Find a valid path from one node to many
}
\examples{
edges <- data.frame(
  parent = c("A", "A", "B", "Z"),
  child =  c("B", "Z", "Z", "F")
)

graph <- graph_builder() |>
  populate_edges(edges, parent, child) |>
  build_acyclic()

find_path_one_to_many(graph, "A", edges$child)
}
\seealso{
Other analyze graphs: 
\code{\link{find_all_paths}()},
\code{\link{find_path}()},
\code{\link{get_all_leaves}()},
\code{\link{get_all_roots}()},
\code{\link{get_leaves_under}()},
\code{\link{get_roots_over}()},
\code{\link{least_common_parents}()}
}
\concept{analyze graphs}
