% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_split.R
\name{best_split}
\alias{best_split}
\title{Find the best split for a stratum}
\usage{
best_split(
  z,
  X,
  strata,
  ist,
  nc_list,
  nt_list,
  wMax = 5,
  wEach = 1,
  solver = "Rglpk",
  integer = FALSE,
  min_split = 10,
  threads = threads
)
}
\arguments{
\item{z}{Vector of treatment assignment}

\item{X}{Covariate matrix or data.frame}

\item{strata}{vector of initial strata assignments; only used if \code{object} is not supplied.
Can be \code{NULL}, in which case an initial stratification using the quintiles of the
propensity score is generated using \code{\link{prop_strat}()} and the generated
propensity score is also added to the X matrix as an extra covariate}

\item{ist}{the stratum to be split}

\item{nc_list}{a list of choices for the \code{nc} parameter in \code{\link{split_stratum}()}.
Each element is a vector with entries corresponding to the number of control
units that should be placed in each new stratum}

\item{nt_list}{a list of choices for the \code{nt} parameter in \code{\link{split_stratum}()}.
Each element is a vector with entries corresponding to the number of treated
units that should be placed in each new stratum}

\item{wMax}{the weight the objective places on the maximum epsilon}

\item{wEach}{the weight the objective places on each epsilon}

\item{solver}{character specifying the optimization software to use.
Options are "Rglpk" or "gurobi". The default is "gurobi"}

\item{integer}{boolean whether to use integer programming instead of randomized rounding.
Default is \code{FALSE}. It is not recommended to set this to \code{TRUE} as the problem may never finish}

\item{min_split}{a numeric specifying the minimum number of each control and treated units
to be tolerated in a stratum. Any combination of elements
from \code{nc_list} and \code{nt_list} that violate this are skipped}

\item{threads}{how many threads to use in the optimization if using "gurobi" as the solver. Default will use all available threads}
}
\value{
A list containing the following elements:
\itemize{
\item{valuesIP, valuesLP: }{matrices containing integer and linear programming
scaled objective values for each sample size tried, with rows corresponding to the
elements of \code{nc_list} and columns corresponding to the elements of \code{nt_list}}
\item{besti, bestj: }{indices of the best sample sizes in \code{nc_list} and in \code{nt_list}, respectively}
\item{n_smds: }{number of standardized mean differences contributing to the objective values
(multiply the scaled objective values by this number to get the true objective values)}
\item{n_fracs: }{number of units with fractional LP solutions in the best split}
\item{rand_c_prop, rand_t_prop: }{proportions of the control and treated units in each
stratum that were selected with randomness for the best split}
\item{pr: }{linear programming solution for the best split,
with rows corresponding to the strata and columns to the units}
\item{selection: }{vector of selected strata for each unit
in the initial stratum to be split for the best split}
}
}
\description{
Runs \code{\link{split_stratum}()} many times and selects the best result.
}
\examples{

# Generate a small data set
set.seed(25)
samp <- sample(1:nrow(rhc_X), 1000)
cov_samp <- sample(1:26, 10)

# Create some strata
ps <- prop_strat(z = rhc_X[samp, "z"],
                 X = rhc_X[samp, cov_samp], nstrata = 5)

# Save the sample sizes
tab <- table(ps$z, ps$base_strata)

# Choose the best sample sizes among the options provided
best_split(z = ps$z, X = ps$X, strata = ps$base_strata, ist = 1,
           nc_list = list(c(floor(tab[1, 1] * 0.25), ceiling(tab[1, 1] * 0.75)),
                          c(floor(tab[1, 1] * 0.4), ceiling(tab[1, 1] * 0.6))),
           nt_list = list(c(floor(tab[2, 1] * 0.3), ceiling(tab[2, 1] * 0.7))),
           min_split = 5)
}
