% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_eff.R
\name{crit}
\alias{crit}
\title{Master function for the criterion function}
\usage{
crit(criterion, M, k = 0, par_int = c(1), matB = NA)
}
\arguments{
\item{criterion}{character variable with the chosen optimality criterion. Can be one of the following:
\itemize{
\item 'D-Optimality'
\item 'Ds-Optimality'
\item 'A-Optimality'
\item 'I-Optimality'
\item 'L-Optimality'
}}

\item{M}{information matrix for which the criterion value wants to be calculated.}

\item{k}{numeric variable with the number of parameters of the model. Taken from the number of rows of the matrix if omitted.}

\item{par_int}{numeric vector with the index of the parameters of interest of the model. Only for "Ds-Optimality".}

\item{matB}{optional matrix of dimensions k x k, for I- and L-optimality.}
}
\value{
Numeric value of the optimality criterion for the information matrix.
}
\description{
Depending on the criterion input, the function returns the output of the corresponding criterion function given
the information matrix.
}
