% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-config.R
\name{otp_make_config}
\alias{otp_make_config}
\title{Make Config Object}
\usage{
otp_make_config(type, version = 1)
}
\arguments{
\item{type}{Which type of config file to create, "otp", "build", "router"}

\item{version}{version of OPT e.g. 1 or 2}
}
\description{
OTP can be configured using three json files `otp-config.json`,
`build-config.json`, and `router-config.json`. This function
creates a named list for each config file and
populates the defaults values.
}
\details{
For more details see:
http://docs.opentripplanner.org/en/latest/Configuration
}
\examples{
{
  conf <- otp_make_config("build")
  conf <- otp_make_config("router")
}
}
\seealso{
Other setup: 
\code{\link{otp_build_graph}()},
\code{\link{otp_check_java}()},
\code{\link{otp_check_version}()},
\code{\link{otp_dl_demo}()},
\code{\link{otp_dl_jar}()},
\code{\link{otp_setup}()},
\code{\link{otp_stop}()},
\code{\link{otp_validate_config}()},
\code{\link{otp_write_config}()}
}
\concept{setup}
