% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snap.R
\name{ors_snap}
\alias{ors_snap}
\title{Openrouteservice Snapping}
\usage{
ors_snap(
  locations,
  profile = ors_profile(),
  radius,
  format = c("geojson", "json"),
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{locations}{List of \verb{longitude, latitude} coordinate pairs, alternatively a two column \code{matrix} or \code{data.frame}.}

\item{profile}{Route profile, defaults to \code{"driving-car"}.}

\item{radius}{Maximum radius in meters around given coordinates to search for graph edges}

\item{format}{Response format, defaults to \code{"geojson"}}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/v2/snap/{profile}/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
Coordinates of snapped location(s) and distance to the original point(s) structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}

\itemize{
\item for \code{"sf"}, a simple features \code{\link[sf]{sf}} object.
}
}
\description{
Snap coordinates to road network
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
locations <- list(
  c(8.669629, 49.413025),
  c(8.675841, 49.418532),
  c(8.665144, 49.415594)
)

# query for locations snapped onto the OpenStreetMap road network
res <- ors_snap(locations, radius = 350)
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
