% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{ors_optimization}
\alias{ors_optimization}
\alias{jobs}
\alias{vehicles}
\title{Openrouteservice Optimization}
\usage{
ors_optimization(
  jobs,
  vehicles,
  matrix = NULL,
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text")
)

jobs(
  id,
  location,
  location_index,
  service,
  amount,
  skills,
  priority,
  time_windows
)

vehicles(
  id,
  profile,
  start,
  start_index,
  end,
  end_index,
  capacity,
  skills,
  time_window
)
}
\arguments{
\item{jobs}{\code{data.frame} describing the places to visit}

\item{vehicles}{\code{data.frame} describing the available vehicles}

\item{matrix}{Optional two-dimensional array describing a custom travel-time
matrix}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/optimization/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}

\item{id}{An integer used as unique identifier}

\item{location}{Coordinates array}

\item{location_index}{Index of relevant row and column in custom matrix}

\item{service}{Job service duration (defaults to 0)}

\item{amount}{An array of integers describing multidimensional quantities}

\item{skills}{An array of integers defining skills}

\item{priority}{An integer in the [0, 10] range describing priority level
(defaults to 0)}

\item{time_windows}{An array of time_window objects describing valid slots
for job service start}

\item{profile}{routing profile (defaults to car)}

\item{start}{coordinates array}

\item{start_index}{index of relevant row and column in custom matrix}

\item{end}{coordinates array}

\item{end_index}{index of relevant row and column in custom matrix}

\item{capacity}{an array of integers describing multidimensional quantities}

\item{time_window}{a time_window object describing working hours}
}
\value{
Solution computed by the optimization endpoint formatted as described \href{https://github.com/VROOM-Project/vroom/blob/master/docs/API.md#output}{here} and structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}
}
\description{
Optimize a fleet of vehicles on a number of jobs. For more information, see
the
\href{https://github.com/VROOM-Project/vroom/blob/master/docs/API.md}{Vroom
project API documentation}.

The helper functions \code{jobs()} and \code{vehicles()} create
data.frames which can be used as arguments to \code{ors_optimization()}.
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
home_base <- c(2.35044, 48.71764)

vehicles <- vehicles(
  id = 1:2,
  profile = "driving-car",
  start = home_base,
  end = home_base,
  capacity = 4,
  skills = list(c(1, 14), c(2, 14)),
  time_window = c(28800, 43200)
)

locations <- list(
  c(1.98935, 48.701),
  c(2.03655, 48.61128),
  c(2.39719, 49.07611),
  c(2.41808, 49.22619),
  c(2.28325, 48.5958),
  c(2.89357, 48.90736)
)

jobs <- jobs(
  id = 1:6,
  service = 300,
  amount = 1,
  location = locations,
  skills = list(1, 1, 2, 2, 14, 14)
)

try( ors_optimization(jobs, vehicles) )
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
