% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/air_quality.R
\name{air_quality}
\alias{air_quality}
\title{Retrieve air quality data from the Open-Meteo API}
\usage{
air_quality(
  location,
  start = NULL,
  end = NULL,
  hourly = NULL,
  timezone = "auto"
)
}
\arguments{
\item{location}{Required. The location for which data will be retrieved.
Supplied as either a \code{c(latitude,longitude)} WGS84 coordinate pair or a
place name string (with co-ordinates obtained via \code{\link[=geocode]{geocode()}}).}

\item{start, end}{Start and end dates in ISO 8601 (e.g. "2020-12-31"). If no
dates are supplied, data for the next 5 days will be provided by default.}

\item{hourly}{Required. An air quality variable accepted by the
API, or list thereof. See details below.}

\item{timezone}{specify timezone for time data as a string, i.e.
"australia/sydney" (defaults to "auto", the timezone local to the specified
\code{location}).}
}
\value{
Requested air quality data for the given location and time, as a
tidy tibble.
}
\description{
\code{air_quality()} calls the Open-Meteo Air Quality API to obtain pollutant,
pollen, and particulate data. Historical and forecasted data is available.

Refer to the API documentation at:
\url{https://open-meteo.com/en/docs/air-quality-api}
}
\details{
You will need to specify at least one air quality variable, such as PM10 or
Carbon Monoxide, that you want forecasted data for. These variables are
sampled or aggregated at \emph{hourly} intervals, and can be supplied as a list to
request multiple variables over the same time period.

Example hourly air quality variables include:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{pm10} \tab Particulate matter smaller than 10 micrometers across \cr
   \code{carbon_monoxide} \tab 10m concentration in micrograms per cubic meter \cr
   \code{european_aqi} \tab European Air Quality Index \cr
   \code{us_aqi} \tab United States Air Quality Index \cr
   \code{dust} \tab Saharan dust particles 10m above ground \cr
}


Full documentation for the forecast API is available at:
\url{https://open-meteo.com/en/docs/air-quality-api}
}
\examples{
\donttest{
# obtain Carbon Monoxide levels for Beijing over the next 5 days
air_quality("Beijing", hourly = "carbon_monoxide")
}
}
