% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linResPlot.R
\name{linResPlot}
\alias{linResPlot}
\title{Create simple regression plot with residual plot}
\usage{
linResPlot(
  x,
  y,
  axes = FALSE,
  wBox = TRUE,
  wLine = TRUE,
  lCol = "#00000088",
  lty = 1,
  lwd = 1,
  main = "",
  xlab = "",
  ylab = "",
  marRes = NULL,
  col = fadeColor(4, "88"),
  pch = 20,
  cex = 1.5,
  yR = 0.1,
  ylim = NULL,
  subset = NULL,
  ...
)
}
\arguments{
\item{x}{Predictor variable.}

\item{y}{Outcome variable.}

\item{axes}{Whether to plot axis labels.}

\item{wBox}{Whether to plot boxes around each plot.}

\item{wLine}{Add a regression line.}

\item{lCol}{Line color.}

\item{lty}{Line type.}

\item{lwd}{Line width.}

\item{main}{Title for the top plot.}

\item{xlab}{x-label.}

\item{ylab}{y-label.}

\item{marRes}{Margin for the residuals plot.}

\item{col}{Color of the points.}

\item{pch}{Plotting character of points.}

\item{cex}{Size of points.}

\item{yR}{An additional vertical stretch factor on the plot.}

\item{ylim}{y-limits.}

\item{subset}{Boolean vector, if wanting a subset of the data.}

\item{\dots}{Additional arguments passed to both plots.}
}
\description{
Create a simple regression plot with residual plot.
}
\examples{

# Currently seems broken for this example.
n <- 25
x <- runif(n)
y <- 5 * x + rnorm(n)
myMat <- rbind(matrix(1:2, 2))
myW <- 1
myH <- c(1, 0.45)
par(mar = c(0.35, 0.654, 0.35, 0.654))
layout(myMat, myW, myH)
linResPlot(x, y, col = COL[1, 2])
}
\seealso{
\code{\link{makeTube}}
}
