% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{oh_stat_public_holidays}
\alias{oh_stat_public_holidays}
\alias{oh_stat_school_holidays}
\title{Reads statistical data about stored holidays}
\usage{
oh_stat_public_holidays(country, subdivision = NULL)

oh_stat_school_holidays(country, subdivision = NULL)
}
\arguments{
\item{country}{Country ISO code (e.g., "DE").}

\item{subdivision}{Optional subdivision ID (if you want holidays for a
specific state/province).}
}
\value{
A data frame containing youngestStartDate and oldestStartDate.
}
\description{
Reads statistical data about stored holidays
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Statistical data about public holidays in Germany
oh_stat_public_holidays(country = "DE")

# Statistical data about school holidays in Hamburg
oh_stat_school_holidays(country = "DE", subdivision = "DE-HH")
\dontshow{\}) # examplesIf}
}
