% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendLevel.R
\name{trendLevel}
\alias{trendLevel}
\title{Plot heat map trends}
\usage{
trendLevel(
  mydata,
  pollutant = "nox",
  x = "month",
  y = "hour",
  type = "year",
  rotate.axis = c(90, 0),
  n.levels = c(10, 10, 4),
  limits = c(0, 100),
  cols = "default",
  auto.text = TRUE,
  key.header = "use.stat.name",
  key.footer = pollutant,
  key.position = "right",
  key = TRUE,
  labels = NA,
  breaks = NA,
  statistic = c("mean", "max", "min", "median", "frequency", "sum", "sd", "percentile"),
  percentile = 95,
  stat.args = NULL,
  stat.safe.mode = TRUE,
  drop.unused.types = TRUE,
  col.na = "white",
  plot = TRUE,
  ...
)
}
\arguments{
\item{mydata}{The openair data frame to use to generate the \code{\link[=trendLevel]{trendLevel()}}
plot.}

\item{pollutant}{The name of the data series in \code{mydata} to sample to produce
the \code{\link[=trendLevel]{trendLevel()}} plot.}

\item{x, y, type}{The name of the data series to use as the \code{\link[=trendLevel]{trendLevel()}}
x-axis, y-axis or conditioning variable, passed to \code{\link[=cutData]{cutData()}}. These are
used before applying \code{statistic}. \code{\link[=trendLevel]{trendLevel()}} does not allow duplication
in \code{x}, \code{y} and \code{type} options.}

\item{rotate.axis}{The rotation to be applied to \code{trendLevel} \code{x} and \code{y}
axes. The default, \code{c(90, 0)}, rotates the x axis by 90 degrees but does
not rotate the y axis. If only one value is supplied, this is applied to
both axes; if more than two values are supplied, only the first two are
used.}

\item{n.levels}{The number of levels to split \code{x}, \code{y} and \code{type} data into
if numeric. The default, \code{c(10, 10, 4)}, cuts numeric \code{x} and \code{y} data into
ten levels and numeric \code{type} data into four levels. This option is ignored
for date conditioning and factors. If less than three values are supplied,
three values are determined by recursion; if more than three values are
supplied, only the first three are used.}

\item{limits}{The colour scale range to use when generating the
\code{\link[=trendLevel]{trendLevel()}} plot.}

\item{cols}{The colour set to use to colour the \code{\link[=trendLevel]{trendLevel()}} surface.
\code{cols} is passed to \code{\link[=openColours]{openColours()}} for evaluation.}

\item{auto.text}{Automatic routine text formatting. \code{auto.text = TRUE} passes
common \code{lattice} labelling terms (e.g. \code{xlab} for the x-axis, \code{ylab} for
the y-axis and \code{main} for the title) to the plot via \code{\link[=quickText]{quickText()}} to
provide common text formatting.  The alternative \code{auto.text = FALSE} turns
this option off and passes any supplied labels to the plot without
modification.}

\item{key.header, key.footer}{Adds additional text labels above and/or below
the scale key, respectively. For example, passing the options \verb{key.header = "", key.footer = c("mean","nox")} adds the addition text as a scale footer.
If enabled (\code{auto.text = TRUE}), these arguments are passed to the scale
key (\code{\link[=drawOpenKey]{drawOpenKey()}}) via \code{\link[=quickText]{quickText()}} to handle formatting. The term
\code{"get.stat.name"}, used as the default \code{key.header} setting, is reserved
and automatically adds statistic function names or defaults to \code{"level"}
when unnamed functions are requested via \code{statistic}.}

\item{key.position}{Location where the scale key should be plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}, and \code{"left"}.}

\item{key}{Fine control of the scale key via \code{\link[=drawOpenKey]{drawOpenKey()}}.}

\item{breaks, labels}{If a categorical colour scale is required then \code{breaks}
should be specified. These should be provided as a numeric vector, e.g.,
\code{breaks = c(0, 50, 100, 1000)}. Users should set the maximum value of
\code{breaks} to exceed the maximum data value to ensure it is within the
maximum final range, e.g., 100--1000 in this case. Labels will
automatically be generated, but can be customised by passing a character
vector to \code{labels}, e.g., \code{labels = c("good", "bad", "very bad")}. In this
example, \code{0 - 50} will be \code{"good"} and so on. Note there is one less label
than break.}

\item{statistic}{The statistic to apply when aggregating the data; default is
the mean. Can be one of \code{"mean"}, \code{"max"}, \code{"min"}, \code{"median"},
\code{"frequency"}, \code{"sum"}, \code{"sd"}, \code{"percentile"}. Note that \code{"sd"} is the
standard deviation, \code{"frequency"} is the number (frequency) of valid
records in the period and \code{"data.cap"} is the percentage data capture.
\code{"percentile"} is the percentile level (\%) between 0-100, which can be set
using the \code{"percentile"} option. Functions can also be sent directly via
\code{statistic}; see 'Details' for more information.}

\item{percentile}{The percentile level used when \code{statistic = "percentile"}.
The default is 95\%.}

\item{stat.args}{Additional options to be used with \code{statistic} if this is a
function. The extra options should be supplied as a list of named
parameters; see 'Details' for more information.}

\item{stat.safe.mode}{An addition protection applied when using functions
directly with \code{statistic} that most users can ignore. This option returns
\code{NA} instead of running \code{statistic} on binned sub samples that are empty.
Many common functions terminate with an error message when applied to an
empty dataset. So, this option provides a mechanism to work with such
functions. For a very few cases, e.g., for a function that counted missing
entries, it might need to be set to \code{FALSE}; see 'Details' for more
information.}

\item{drop.unused.types}{Hide unused/empty \code{type} conditioning cases. Some
conditioning options may generate empty cases for some data sets, e.g. a
hour of the day when no measurements were taken. Empty \code{x} and \code{y} cases
generate 'holes' in individual plots. However, empty \code{type} cases would
produce blank panels if plotted. Therefore, the default, \code{TRUE}, excludes
these empty panels from the plot. The alternative \code{FALSE} plots all \code{type}
panels.}

\item{col.na}{Colour to be used to show missing data.}

\item{plot}{Should a plot be produced? \code{FALSE} can be useful when analysing
data to extract plot components and plotting them in other ways.}

\item{...}{Addition options are passed on to \code{\link[=cutData]{cutData()}} for \code{type} handling
and \code{\link[lattice:levelplot]{lattice::levelplot()}} for finer control of the plot itself.}
}
\value{
an \link[=openair-package]{openair} object.
}
\description{
The trendLevel function provides a way of rapidly showing a large amount of
data in a condensed form. In one plot, the variation in the concentration of
one pollutant can to shown as a function of three other categorical
properties. The default version of the plot uses y = hour of day, x = month
of year and type = year to provide information on trends, seasonal effects
and diurnal variations. However, x, y and type and summarising statistics can
all be modified to provide a range of other similar plots.
}
\details{
\code{\link[=trendLevel]{trendLevel()}} allows the use of third party summarising functions via the
\code{statistic} option. Any additional function arguments not included within a
function called using \code{statistic} should be supplied as a list of named
parameters and sent using \code{stat.args}. For example, the encoded option
\code{statistic = "mean"} is equivalent to \verb{statistic = mean, stat.args = list(na.rm = TRUE)} or the R command \code{mean(x, na.rm = TRUE)}. Many R
functions and user's own code could be applied in a similar fashion, subject
to the following restrictions: the first argument sent to the function must
be the data series to be analysed; the name 'x' cannot be used for any of the
extra options supplied in \code{stat.args}; and the function should return the
required answer as a numeric or \code{NA}. Note: If the supplied function returns
more than one answer, currently only the first of these is retained and used
by \code{\link[=trendLevel]{trendLevel()}}. All other returned information will be ignored without
warning. If the function terminates with an error when it is sent an empty
data series, the option \code{stat.safe.mode} should not be set to \code{FALSE} or
\code{\link[=trendLevel]{trendLevel()}} may fail. Note: The \code{stat.safe.mode = TRUE} option returns an
NA without warning for empty data series.
}
\examples{
# basic use
# default statistic = "mean"
trendLevel(mydata, pollutant = "nox")

# applying same as 'own' statistic
my.mean <- function(x) mean(x, na.rm = TRUE)
trendLevel(mydata, pollutant = "nox", statistic = my.mean)

# alternative for 'third party' statistic
# trendLevel(mydata, pollutant = "nox", statistic = mean,
#           stat.args = list(na.rm = TRUE))

\dontrun{
# example with categorical scale
trendLevel(mydata,
  pollutant = "no2",
  border = "white", statistic = "max",
  breaks = c(0, 50, 100, 500),
  labels = c("low", "medium", "high"),
  cols = c("forestgreen", "yellow", "red")
)
}
}
\seealso{
Other time series and trend functions: 
\code{\link{TheilSen}()},
\code{\link{calendarPlot}()},
\code{\link{runRegression}()},
\code{\link{smoothTrend}()},
\code{\link{timePlot}()},
\code{\link{timeProp}()},
\code{\link{timeVariation}()}
}
\author{
Karl Ropkins

David Carslaw

Jack Davison
}
\concept{time series and trend functions}
