% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runRegression.R
\name{runRegression}
\alias{runRegression}
\title{Rolling regression for pollutant source characterisation.}
\usage{
runRegression(mydata, x = "nox", y = "pm10", run.len = 3, date.pad = TRUE)
}
\arguments{
\item{mydata}{A data frame with  columns for \code{date} and at least two
variables for use in a regression.}

\item{x}{The column name of the \code{x} variable for use in a linear
regression \code{y = m.x + c}.}

\item{y}{The column name of the \code{y} variable for use in a linear
regression \code{y = m.x + c}.}

\item{run.len}{The window width to be used for a rolling regression. A value
of 3 for example for hourly data will consider 3 one-hour time sequences.}

\item{date.pad}{Should gaps in time series be filled before calculations are
made?}
}
\value{
A tibble with \code{date} and calculated regression coefficients and
other information to plot dilution lines.
}
\description{
This function calculates rolling regressions for input data with a set window
width. The principal use of the function is to identify "dilution lines"
where the ratio between two pollutant concentrations is invariant. The
original idea is based on the work of Bentley (2004).
}
\details{
The intended use is to apply the approach to air pollution data to extract
consecutive points in time where the ratio between two pollutant
concentrations changes by very little. By filtering the output for high R2
values (typically more than 0.90 to 0.95), conditions where local source
dilution is dominant can be isolated for post processing. The function is
more fully described and used in the \code{openair} online manual, together
with examples.
}
\examples{
# Just use part of a year of data
output <- runRegression(selectByDate(mydata, year = 2004, month = 1:3),
  x = "nox", y = "pm10", run.len = 3
)

output
}
\references{
For original inspiration:

Bentley, S. T. (2004). Graphical techniques for constraining estimates of
aerosol emissions from motor vehicles using air monitoring network data.
Atmospheric Environment,(10), 1491–1500.
https://doi.org/10.1016/j.atmosenv.2003.11.033

Example for vehicle emissions high time resolution data:

Farren, N. J., Schmidt, C., Juchem, H., Pöhler, D., Wilde, S. E., Wagner, R.
L., Wilson, S., Shaw, M. D., & Carslaw, D. C. (2023). Emission ratio
determination from road vehicles using a range of remote emission sensing
techniques. Science of The Total Environment, 875.
https://doi.org/10.1016/j.scitotenv.2023.162621.
}
\seealso{
Other time series and trend functions: 
\code{\link{TheilSen}()},
\code{\link{calendarPlot}()},
\code{\link{smoothTrend}()},
\code{\link{timePlot}()},
\code{\link{timeProp}()},
\code{\link{timeVariation}()},
\code{\link{trendLevel}()}
}
\concept{time series and trend functions}
