% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{make_data_NHPP_KDE_Markov_kernel}
\alias{make_data_NHPP_KDE_Markov_kernel}
\title{Get NHPP data for all edges (Markov KDE)}
\usage{
make_data_NHPP_KDE_Markov_kernel(Tb.trees, add.psd = TRUE)
}
\arguments{
\item{Tb.trees}{data.frame. A tibble obtained with the 'path_hamming_over_trees_KDE' function.}

\item{add.psd}{logical. Whether to add pseudodata or not. Default is TRUE.}
}
\value{
A list with changing times between states for all edges of a given sample of trees.
}
\description{
Gets data on changing times between states for all edges of a given sample of trees for the Markov kernel density estimator (KDE).
}
\examples{
data("hym_hm")
# Get hamming data from the head characters.
hm <- hym_hm$head
# Make NHPP path data.
nhpp <- make_data_NHPP_KDE_Markov_kernel(hm)
# Check NHPP path data for an arbitrary branch.
nhpp[[5]]

}
\author{
Sergei Tarasov
}
