% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{estimate_band_W}
\alias{estimate_band_W}
\title{Estimate bandwidth}
\usage{
estimate_band_W(
  tree.discr,
  data.path,
  band.width = c("bw.nrd0", "bw.nrd0", "bw.ucv", "bw.bcv", "bw.SJ")
)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{data.path}{list. A list of path data obtained from the 'make_data_NHPP_KDE_Markov_kernel' function.}

\item{band.width}{character. Bandwidth selectors for the KDE, as in density.}
}
\value{
A numeric vector.
}
\description{
Estimate the bandwidth for the Markov KDE.
}
\examples{
data("hym_hm", "hym_tree")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get hamming data from the head characters.
hm <- hym_hm$head
# Make NHPP path data.
nhpp_psd <- make_data_NHPP_KDE_Markov_kernel(hm, add.psd = TRUE)
# Calculate bandwidth.
bdw <- estimate_band_W(tree_discr, nhpp_psd, band.width = "bw.nrd0")
mean(bdw)

}
\author{
Sergei Tarasov
}
