% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{edge_profiles4plotting}
\alias{edge_profiles4plotting}
\title{Make edge profiles for plotting}
\usage{
edge_profiles4plotting(tree.discr, Edge.KDE.stat)
}
\arguments{
\item{tree.discr}{phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Edge.KDE.stat}{list. A list with the distributions of the estimated parameter of KDEs for each edge.}
}
\value{
A tibble with X and Y coordinates and other information necessary for making an edgeplot.
}
\description{
Gets the information necessary for making an edgeplot, where the tree is plotted in a space where the x axis is the time and y axis the scale of the desired statistics.
}
\examples{
data("hym_tree", "hym_kde")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get smoothing of normalized edge KDE data for mean rates.
Edge_KDE <- hym_kde$head
Edge_KDE_stat <- Edge_KDE$loess.lambda.mean
# Make edgeplot nhpp data.
stat_prof <- edge_profiles4plotting(tree_discr, Edge_KDE_stat)

}
\author{
Sergei Tarasov
}
