% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-sim.R
\name{get_sim_p}
\alias{get_sim_p}
\alias{get_sim_p.integer}
\alias{get_sim_p.numeric}
\alias{get_sim_p.matrix}
\alias{get_sim_p.sim_index}
\alias{get_sim_p.default}
\title{Get similarity p-value}
\usage{
get_sim_p(pop_sim, ...)

\method{get_sim_p}{integer}(pop_sim, ...)

\method{get_sim_p}{numeric}(pop_sim, group, ...)

\method{get_sim_p}{matrix}(pop_sim, group, ...)

\method{get_sim_p}{sim_index}(pop_sim, group, ...)

\method{get_sim_p}{default}(
  pop_sim,
  group,
  type,
  min_its = 1000,
  max_its = 1e+05,
  signif = 0.05,
  log_dismiss = log(1e-06),
  group_sim = "average",
  ...
)
}
\arguments{
\item{pop_sim}{An object representing the similarities of an indexed population of objects.}

\item{...}{Arguments for \code{get_sim_p}.}

\item{group}{Character or integer vector specifying names/indices of subgroup for which to calculate a group similarity p-value.}

\item{type}{Either "matrix", "sim_index" or "numeric" - the type of the \code{pop_sim} object.}

\item{min_its}{Minimum number of simulated group similarities to calculate}

\item{max_its}{Maximum number of simulated group similarities to calculate}

\item{signif}{Threshold p-value of statistical significance}

\item{log_dismiss}{Threshold of log probability, below which to trigger return of current estimated p-value}

\item{group_sim}{String Either "average" or "min", determining how to calculate the similarity of a group of term sets over all pairwise combinations of group members}
}
\value{
p-value.
}
\description{
p-value of group similarity, calculated by estimating the proportion by random sampling of groups the same size as \code{group} which have at least as great group similarity than does \code{group}.
}
\seealso{
\code{\link{get_sim}} \code{\link{sample_group_sim}}
}
