% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-antecedent.R
\name{simulate_antecedent}
\alias{simulate_antecedent}
\title{simulate_antecedent}
\usage{
simulate_antecedent(x, i, j, nsim, heterogenous = FALSE, ...)
}
\arguments{
\item{x}{ppp}

\item{i}{Mark of points that are not not changed.}

\item{j}{Mark of points that are randomized.}

\item{nsim}{Number of patterns to simulate.}

\item{heterogenous}{If TRUE, points with the mark j are randomized using a heterogeneous
Poisson process.}

\item{...}{Arguments passed to \code{spatstat.explore::density.ppp()}.}
}
\value{
list
}
\description{
Simulate heterogenous pattern
}
\details{
Simulate point patterns as null model data for \code{spatstat.explore::envelope()} using
antecedent conditions as null model. \code{x} must be a marked point pattern with
two types of marks. Antecedent conditions are suitable as a null model if points
of type i may influence points of type j, but not the other way around (Velazquez et al 2016).
One example are the positions of seedlings that may be influenced by the position
of mature trees.

Returns a \code{list} with \code{ppp} objects.
}
\examples{
set.seed(42)
pattern_a <- spatstat.random::runifpoint(n = 20)
spatstat.geom::marks(pattern_a) <- "a"
pattern_b <- spatstat.random::runifpoint(n = 100)
spatstat.geom::marks(pattern_b) <- "b"
pattern <- spatstat.geom::superimpose(pattern_a, pattern_b)

null_model <- simulate_antecedent(x = pattern, i = "a", j = "b", nsim = 19)
spatstat.explore::envelope(Y = pattern, fun = spatstat.explore::pcf,
nsim = 19, simulate = null_model)

}
\references{
Velázquez, E., Martínez, I., Getzin, S., Moloney, K.A., Wiegand, T., 2016. An evaluation
of the state of spatial point pattern analysis in ecology. Ecography 39, 1–14.
<https://doi.org/10.1111/ecog.01579>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton, USA. <isbn:978-1-4200-8254-8>
}
\seealso{
\code{\link[spatstat.explore]{envelope}}
}
