% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_line}
\alias{svg_line}
\title{Addition of an \code{line} element}
\usage{
svg_line(
  svg,
  x1,
  y1,
  x2,
  y2,
  stroke = NULL,
  stroke_width = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x1, y1}{The \code{x} and \code{y} positions of the line's start point.}

\item{x2, y2}{The \code{x} and \code{y} positions of the line's end point.}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_line()} function adds a line to an \code{svg} object. The line is drawn
using a start point (\code{x1} and \code{y1}) and an end point (\code{x2} and \code{y2}) points.
These positions are in units of \code{px}.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# line element
svg <-
  SVG(width = 100, height = 50) \%>\%
    svg_line(
      x1 = 5, y1 = 5,
      x2 = 95, y2 = 45,
      stroke = "blue"
    )
}

}
