% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anims.R
\name{anims}
\alias{anims}
\title{Express animations for an element}
\usage{
anims(...)
}
\arguments{
\item{...}{One or more animations that included the use of \verb{anim_*()}
functions, expressed as two-sided formulas. The LHS provides the keyframe
time (in units of seconds) and the RHS is the associated \verb{anim_*()} call.}
}
\value{
A tibble of animation directives.
}
\description{
All SVG element functions in \strong{omsvg} (the \verb{svg_*()} functions) are
animatable through their \code{anims} argument. The \code{anims()} function should be
used with that argument should we want to express animations for the element.
Within the \code{anims()} function call, we can insert a list of formulas that
incorporate calls to any of the \verb{anim_*()} functions (e.g.,
\code{\link[=anim_position]{anim_position()}}, \code{\link[=anim_rotation]{anim_rotation()}}, etc.), and, have keyframe times as part
of the formula.
}
\details{
A useful template to use for an \code{anims()} call within an \verb{svg_*()} function
is:

\preformatted{
anims = anims(
  <time_i> ~ <anim_fn>(...),
  ...,
  <time_n> ~ <anim_fn>(...)
  )
}

We can also use multiple calls to \verb{anim_*()} functions for each distinct keyframe
time by placing those calls in a list:

\preformatted{
anims = anims(
  <time_i> ~ list(
    <anim_fn_x>(...),
    <anim_fn_y>(...)
    ),
  ...,
  <time_n> ~ list(
    <anim_fn_x>(...),
    <anim_fn_y>(...)
    )
  )
}
}
\examples{
if (interactive()) {

# Basic animation of an element's
# position (moving to a new `x` and
# `y` position)
svg_1 <-
  SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "magenta",
      fill = "lightblue"
    ),
    anims = anims(
      2.0 ~ anim_position(x = 100, y = 50)
    )
  )

# We can define multiple animations
# for a single element: put them in a
# `list()`; the `easing_fn` function for
# both `anim_*()` function is no longer
# linear but now eases in and out
svg_2 <-
  SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "black",
      fill = "yellow"
    ),
    anims = anims(
      0.5 ~ list(
        anim_position(x = 50, y = 50, easing_fn = ease_in_out()),
        anim_rotation(0, easing_fn = ease_in_out())
      ),
      2.0 ~ list(
        anim_position(x = 200, y = 50, easing_fn = ease_in_out()),
        anim_rotation(90, easing_fn = ease_in_out())
      )
    )
  )

# The initial state of the element
# can be used in any `anim_*()`
# function with `initial = TRUE`
svg_3 <-
  SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "black",
      fill = "yellow"
    ),
    anims = anims(
      1.0 ~ list(
        anim_position(initial = TRUE),
        anim_rotation(initial = TRUE)
      ),
      3.0 ~ list(
        anim_position(x = 200, y = 50),
        anim_rotation(90)
      ),
      5.0 ~ list(
        anim_position(initial = TRUE),
        anim_rotation(initial = TRUE)
      )
    )
  )
}

}
