% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side.r
\name{side}
\alias{side}
\title{Left/right side of a data frame or matrix}
\usage{
side(x, side = 1, n = 3)
}
\arguments{
\item{x}{A \code{data.frame} or \code{matrix}.}

\item{side}{Either 1 (left side) or 2 (right side), or \code{'left'} or \code{'right'}. Case is ignored and partial matching is used.}

\item{n}{Number of columns. The default is 3.}
}
\value{
A \code{data.frame} or \code{matrix}.
}
\description{
This function extracts the leftmost or rightmost set of columns of a data frame or matrix.
}
\examples{

side(iris)
side(iris, 2)
side(iris, 'l')
side(iris, 'r')
side(iris, 1, 2)

}
\seealso{
\code{\link{corner}}, \code{\link[utils]{head}}, \code{\link[utils]{tail}}
}
