% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roundedSigDigits.r
\name{roundedSigDigits}
\alias{roundedSigDigits}
\title{Number of significant digits in rounded numbers}
\usage{
roundedSigDigits(x, minReps = 3)
}
\arguments{
\item{x}{Numeric or numeric vector.}

\item{minReps}{Integer. Number of times a digit or sequence of digits that occur after a decimal place needs to be repeated to assume it represents a repeating series and thus is assumed to arise from using decimal places to represent a fraction. Default is 3. For example, if \code{minReps} is 3 then 0.111 would be assumed to represent a repeating value because 1 occurs three times, so -1 would be returned since this decimal can be represented by 1/9 (i.e., division of 1 by a single-digit number). However, if \code{minReps} is 4 then the function would assume that if the value had had four digits, the next digit would not have been a 1, so returns -3 because there are three significant values after the decimal place. When the penultimate digit is >5 and the last digit is equal to the penultimate digit plus 1, then the last digit counts as a repeat of the penultimate digit.  So 0.067 is assumed to have two repeating 6s.  If \code{minReps} is 0 or 1 then the function will (usually) return the negative of the total number of decimal places in the value.}
}
\value{
Integer (number of digits) or \code{NA} (does not appear to be rounded).
}
\description{
This function examines a numeric value (typically with numbers after the decimal place) and estimates either:
\itemize{
	\item The number of significant digits of the numerator and denominator of a fraction that would (approximately) result in the given value.
		\item The number of digits to which an integer may have been rounded, depending on whether the input has values after the decimal place or is an integer. Negative values are treated as positive so the negative of a number will returns the same value as its positive version. See \emph{Details} for more details. \emph{Obviously, values can appear to be rounded or repeating even when they are not!}
}
}
\details{
For values with at least one non-zero digit after a decimal place with no repeated series of digits detected, the function simply returns the total number of digits (ignoring trailing zeros) times -1. For example:
\itemize{
	\item 0.3 returns -1 because there is just one value after the decimal.
	\item 0.34567 returns -5 because there are no repeats up to the 5th decimal place.
	\item 0.1212125 returns -7 because there are no repeats (starting from the right) up to the 7th decimal place.
	\item 0.111117 returns -6 because there are no repeats (starting from the right) up to the 7th decimal place.
}
The function takes account of rounding up:
\itemize{
	\item 0.666 might be a truncated version of 2/3. Two and three each have 1 significant digit, so the function returns -1 (1 value after the decimal place).
	\item 0.667 also returns -1 because this might represent a rounding of 2/3 and it is customary to round digits up if the next digit would have been >5.
	\item 0.3334 returns -4 because it is inappropriate to round 3 up to 4 if the next digit would have been 5 or less.
}

Repeating series are accounted for. For example:
\itemize{
	\item 0.121212 returns -2 because "12" starts repeating after the second decimal place.
	\item 0.000678678678 returns -6 because "678" starts repeating after the 6th place.
	\item 0.678678678 returns -3.
	\item 0.678678679 also returns -3 because 678 could be rounded to 679 if the next digit were 6.
}

Note that you can set the minimum number of times a digit or series needs to be repeated to count as being repeated using the argument \code{minReps}. The default is 3, so digits or series of digits need to be repeated at least 3 times to count a repetition, but this can be changed:
\itemize{
	\item 0.1111 returns -1 using the default requirement for 3 repetitions but -4 if the number of minimum repetitions is 5 or more.
	\item 0.121212 returns -2 using the default requirement for 3 repetitions but -6 if the number of minimum repetitions is 4 or more.
}

Trailing zeros are ignored, so 0.12300 returns -3. When values do not have digits after a decimal place the location of the first non-zero digit from the right is returned as a positive integer. For example:
\itemize{
	\item 234 returns 1 because the first non-zero digit from the right is in the 1s place.
	\item 100 return 3 because the first non-zero digit from the right is in the 100s place.
	\item 70001 returns 1 because the first non-zero digit from the right is in the 1s place.
}

However, note a few oddities:
\itemize{
\item 4E5 returns 6 but 4E50 probably will not return 51 because many computers have a hard time internally representing numbers that large.
\item 4E-5 returns -5 but  probably will not return -50 because many computers have a hard time internally representing numbers that small.
\item -100 and 100 return 3 and -0.12 and 0.12 return -2 because the negative sign is ignored.
\item 0 returns 0.
\item \code{NA} and \code{NaN} returns \code{NA}.
}
}
\examples{
roundedSigDigits(0.3)
roundedSigDigits(0.34567)
roundedSigDigits(0.1212125)
roundedSigDigits(0.111117)
roundedSigDigits(0.666)
roundedSigDigits(0.667)
roundedSigDigits(0.3334)
roundedSigDigits(0.121212)
roundedSigDigits(0.000678678678)
roundedSigDigits(0.678678678)
roundedSigDigits(0.678678679)
roundedSigDigits(0.1111)
roundedSigDigits(0.1111, minReps=5)
roundedSigDigits(0.121212)
roundedSigDigits(0.121212, minReps=4)
roundedSigDigits(234)
roundedSigDigits(100)
roundedSigDigits(70001)
roundedSigDigits(4E5)
roundedSigDigits(4E50)
roundedSigDigits(4E-5)
roundedSigDigits(4E-50)
roundedSigDigits(0)
roundedSigDigits(NA)

x <- c(0.0667, 0.0667, 0.067)
roundedSigDigits(x)
}
