% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corner.r
\name{corner}
\alias{corner}
\title{Corner of a matrix or data frame}
\usage{
corner(x, corner = 1, size = 5)
}
\arguments{
\item{x}{Data frame or matrix.}

\item{corner}{Integer in the set {\code{1, 2, 3, 4}} or character in the set {\code{'topleft', 'topright', 'bottomleft', 'bottomright'}} or in the set {\code{'tl', 'tr', 'bl', 'br'}}. Indicates which corner to return. Integers 1, 2, 3 and 4 correspond to top left, top right, bottom left, and bottom right corners. The default is 1, the top left corner.}

\item{size}{Positive integer, number of rows and columns to return. If there are fewer columns/rows than indicated then all columns/rows are returned.}
}
\value{
A \code{matrix} or \code{data.frame}.
}
\description{
Return a corner of a matrix or data frame (i.e., upper left, upper right, lower left, lower right).
}
\examples{
x <- matrix(1:120, ncol=12, nrow=10)
x
corner(x, 1)
corner(x, 2)
corner(x, 3)
corner(x, 4)
}
\seealso{
\code{\link{side}}, \code{\link[utils]{head}}, \code{\link[utils]{tail}}
}
