% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOLL-G.R
\name{ANOLLG}
\alias{ANOLLG}
\alias{panollg}
\alias{danollg}
\alias{qanollg}
\alias{ranollg}
\alias{hanollg}
\title{A New Odd log-logistic family of distributions (ANOLL-G)}
\usage{
panollg(x, alpha = 1, beta = 1, G = pnorm, ...)

danollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qanollg(q, alpha = 1, beta = 1, G = pnorm, ...)

ranollg(n, alpha = 1, beta = 1, G = pnorm, ...)

hanollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{panollg} gives the distribution function,
 \code{danollg} gives the density,
 \code{qanollg} gives the quantile function,
 \code{hanollg} gives the hazard function and
 \code{ranollg} generates random variables from the A New Odd log-logistic family of
 distributions (ANOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Haghbin et al. (2017) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,\bar{G}^{\alpha\beta-1}[1-\bar{G}^\alpha]^{\beta-1}}{\{[1-\bar{G}^\alpha]^\beta+\bar{G}^{\alpha\beta}\}^2}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
panollg(x)
panollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
danollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(danollg, -3, 3)
qanollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
ranollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
hanollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hanollg, -3, 3)
}
\references{
Haghbin, Hossein, et al. "A new generalized odd log-logistic family of distributions." Communications in Statistics-Theory and Methods 46.20(2017): 9897-9920.
}
