% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/websockerAPIprivate.R
\name{websocketAPIprivate}
\alias{websocketAPIprivate}
\title{websocketAPIprivate Class}
\description{
Private channel of WebSocket API for \href{https://www.okx.com/docs-v5/en/}{Okx exchange v5 API}.
See \href{https://www.okx.com/docs-v5/en/#websocket-api-private-channel}{Private Channel} for more information.
}
\examples{
\dontrun{
tmp <- websocketAPIprivate$new(api_key, secret_key, passphrase)
tmp$connect()
Sys.sleep(1)
tmp$login()

# subscribe account information
msg <- list(
  op = "subscribe",
  args = list(
    list(channel = "account", ccy = "USDT")
  )
)
msg <- jsonlite::toJSON(msg, auto_unbox = TRUE, pretty = TRUE)
tmp$send(msg)

# pass your own callback function
tmp$on_message(function(event) {
  if (event$data == "pong") {
    cat("Bingo!!\n")
  }
})
tmp$send("ping")

tmp$close()
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{channel}}{Private WebSocket url.}

\item{\code{api_key}}{Okx API key.}

\item{\code{secret_key}}{Okx API secret key.}

\item{\code{passphrase}}{Okx API passphrase.}

\item{\code{simulate}}{Whether to use demo trading service.}

\item{\code{ws}}{A websocket::WebSocket object to establish a connection to the server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-websockerAPIprivate-new}{\code{websocketAPIprivate$new()}}
\item \href{#method-websockerAPIprivate-get_timestamp}{\code{websocketAPIprivate$get_timestamp()}}
\item \href{#method-websockerAPIprivate-get_message}{\code{websocketAPIprivate$get_message()}}
\item \href{#method-websockerAPIprivate-get_signature}{\code{websocketAPIprivate$get_signature()}}
\item \href{#method-websockerAPIprivate-connect}{\code{websocketAPIprivate$connect()}}
\item \href{#method-websockerAPIprivate-login}{\code{websocketAPIprivate$login()}}
\item \href{#method-websockerAPIprivate-on_open}{\code{websocketAPIprivate$on_open()}}
\item \href{#method-websockerAPIprivate-on_close}{\code{websocketAPIprivate$on_close()}}
\item \href{#method-websockerAPIprivate-on_message}{\code{websocketAPIprivate$on_message()}}
\item \href{#method-websockerAPIprivate-on_error}{\code{websocketAPIprivate$on_error()}}
\item \href{#method-websockerAPIprivate-send}{\code{websocketAPIprivate$send()}}
\item \href{#method-websockerAPIprivate-close}{\code{websocketAPIprivate$close()}}
\item \href{#method-websockerAPIprivate-clone}{\code{websocketAPIprivate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-new"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-new}{}}}
\subsection{Method \code{new()}}{
Craeate a new websocketAPIprivate object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$new(api_key, secret_key, passphrase, simulate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{Okx API key.}

\item{\code{secret_key}}{Okx API secret key.}

\item{\code{passphrase}}{Okx API passphrase.}

\item{\code{simulate}}{Whether to use demo trading service.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-get_timestamp"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-get_timestamp}{}}}
\subsection{Method \code{get_timestamp()}}{
Get UTC timestamp.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$get_timestamp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-get_message"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-get_message}{}}}
\subsection{Method \code{get_message()}}{
Get the signing messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$get_message(timestamp)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timestamp}}{Retrieve through method \code{get_timestamp}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-get_signature"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-get_signature}{}}}
\subsection{Method \code{get_signature()}}{
Get the signature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$get_signature(secret_key, msg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{secret_key}}{Okx API secret key.}

\item{\code{msg}}{Retrieve through method \code{get_message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-connect"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-connect}{}}}
\subsection{Method \code{connect()}}{
Initiate the connection to the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$connect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-login"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-login}{}}}
\subsection{Method \code{login()}}{
Log in.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$login()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-on_open"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-on_open}{}}}
\subsection{Method \code{on_open()}}{
Called when the connection is established.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$on_open(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-on_close"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-on_close}{}}}
\subsection{Method \code{on_close()}}{
Called when a previously-opened connection is closed.
The event will have 'code' (integer) and 'reason' (one-element character)
elements that describe the remote's reason for closing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$on_close(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-on_message"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-on_message}{}}}
\subsection{Method \code{on_message()}}{
Called each time a message is received from the server.
The event will have a 'data' element, which is the message content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$on_message(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-on_error"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-on_error}{}}}
\subsection{Method \code{on_error()}}{
Called when the connection fails to be established.
The event will have an 'message' element, a character vector of length 1
describing the reason for the error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$on_error(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-send"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-send}{}}}
\subsection{Method \code{send()}}{
Send a message to the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$send(msg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-close"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-close}{}}}
\subsection{Method \code{close()}}{
Close the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websockerAPIprivate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-websockerAPIprivate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIprivate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
