% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restAPI.R
\name{restAPImarket}
\alias{restAPImarket}
\title{restAPImarket Class}
\description{
Wrapper for \href{https://www.okx.com/docs-v5/en/#rest-api-market-data}{REST API MARKET}.
}
\section{Super class}{
\code{\link[okxAPI:restAPI]{okxAPI::restAPI}} -> \code{restAPImarket}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-restAPImarket-candles}{\code{restAPImarket$candles()}}
\item \href{#method-restAPImarket-history_candles}{\code{restAPImarket$history_candles()}}
\item \href{#method-restAPImarket-clone}{\code{restAPImarket$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_body"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_body'><code>okxAPI::restAPI$get_body()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_header"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_header'><code>okxAPI::restAPI$get_header()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_message"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_message'><code>okxAPI::restAPI$get_message()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_request_path"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_request_path'><code>okxAPI::restAPI$get_request_path()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_result"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_result'><code>okxAPI::restAPI$get_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_signature"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_signature'><code>okxAPI::restAPI$get_signature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="get_timestamp"><a href='../../okxAPI/html/restAPI.html#method-restAPI-get_timestamp'><code>okxAPI::restAPI$get_timestamp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="okxAPI" data-topic="restAPI" data-id="initialize"><a href='../../okxAPI/html/restAPI.html#method-restAPI-initialize'><code>okxAPI::restAPI$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPImarket-candles"></a>}}
\if{latex}{\out{\hypertarget{method-restAPImarket-candles}{}}}
\subsection{Method \code{candles()}}{
See \href{https://www.okx.com/docs-v5/en/#rest-api-market-data-get-candlesticks}{Get candlesticks} for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPImarket$candles(instId, process = "identity", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instId}}{Instrument ID, e.g. BTC-USD-190927-5000-C.}

\item{\code{process}}{A function to process the data received from the API. Default to \code{identity}.}

\item{\code{...}}{Other request parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPImarket-history_candles"></a>}}
\if{latex}{\out{\hypertarget{method-restAPImarket-history_candles}{}}}
\subsection{Method \code{history_candles()}}{
See \href{https://www.okx.com/docs-v5/en/#rest-api-market-data-get-candlesticks-history}{Get candlesticks history} for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPImarket$history_candles(instId, process = "identity", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instId}}{Instrument ID, e.g. BTC-USD-190927-5000-C.}

\item{\code{process}}{A function to process the data received from the API. Default to \code{identity}.}

\item{\code{...}}{Other request parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPImarket-clone"></a>}}
\if{latex}{\out{\hypertarget{method-restAPImarket-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPImarket$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
