% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{get_positions_history}
\alias{get_positions_history}
\title{Retrieve the position data}
\usage{
get_positions_history(
  api_key,
  secret_key,
  passphrase,
  count = 90,
  period = 10,
  ...
)
}
\arguments{
\item{api_key}{Okx API key.}

\item{secret_key}{Okx API secret key.}

\item{passphrase}{Okx API passphrase.}

\item{count}{Retrieve position data for a specified number of past days, with a maximum of 90(days)}

\item{period}{Due to the 'Number of results per request' limitation of the API,
the \code{period} parameter must be specified to ensure that the number of position data entries within each period does not exceed 100.}

\item{...}{Other request parameters to be passed, See
\href{https://www.okx.com/docs-v5/en/#rest-api-account-get-positions-history}{Get positions history} for more information.}
}
\value{
Position data
}
\description{
Wrapper for API \href{https://www.okx.com/docs-v5/en/#rest-api-account-get-positions-history}{Get positions history}.
}
\examples{
\dontrun{
positions <- get_positions_history(
  api_key, secret_key, passphrase, count = 90, period = 10,
  instType = "SWAP", mgnMode = "isolated"
)
}

}
