% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_fill_okcolors}
\alias{scale_fill_okcolors}
\title{Custom ggplot2 Fill Scale using okcolors Palettes}
\usage{
scale_fill_okcolors(palette = "obsession", discrete = TRUE, ...)
}
\arguments{
\item{palette}{Character. Name of the palette to use. Must be one of the palettes available in `okcolors()`. Default is `"obsession"`.}

\item{discrete}{Logical. Whether to use a discrete scale (`TRUE`) or a continuous scale (`FALSE`). Default is `TRUE`.}

\item{...}{Additional arguments passed to `ggplot2::discrete_scale()` or `ggplot2::scale_fill_gradientn()`.}
}
\value{
A `Scale` object that can be added to a ggplot2 plot.
}
\description{
Applies a custom discrete or continuous fill scale to ggplot2 plots using a selected palette from the okcolors package.
}
\examples{
ggplot2::ggplot(ggplot2::mpg, ggplot2::aes(class, fill = class)) +
  ggplot2::geom_bar() +
  scale_fill_okcolors("skyscrapers")

ggplot2::ggplot(ggplot2::mpg, ggplot2::aes(displ, hwy, fill = hwy)) +
  ggplot2::geom_tile() +
  scale_fill_okcolors("obsession", discrete = FALSE)

}
