% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{print.ocf}
\alias{print.ocf}
\title{Print Method for ocf Objects}
\usage{
\method{print}{ocf}(x, ...)
}
\arguments{
\item{x}{An \code{\link{ocf}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints an \code{\link{ocf}} object.
}
\description{
Prints an \code{\link{ocf}} object.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(100)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)

## Print.
print(forests)}

}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}
}
\author{
Riccardo Di Francesco
}
