% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{plot.ocf.marginal}
\alias{plot.ocf.marginal}
\title{Plot Method for ocf.marginal Objects}
\usage{
\method{plot}{ocf.marginal}(x, ...)
}
\arguments{
\item{x}{An \code{ocf.marginal} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Plots an \code{ocf.marginal} object.
}
\description{
Plots an \code{ocf.marginal} object.
}
\details{
If standard errors have been estimated, 95\% confidence intervals are shown.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(100)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)

## Marginal effects at the mean.
me <- marginal_effects(forests, eval = "atmean")
plot(me)

## Add standard errors.
honest_forests <- ocf(Y, X, honesty = TRUE)
honest_me <- marginal_effects(honest_forests, eval = "atmean", inference = TRUE)
plot(honest_me)}

}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}.
}
\author{
Riccardo Di Francesco
}
