% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveStatsZC.R
\name{waveStatsZC}
\alias{waveStatsZC}
\title{Calculate wave statistics using zero-crossing method}
\usage{
waveStatsZC(data, Fs, threshold = NULL, plot = FALSE)
}
\arguments{
\item{data}{A numeric vector of water surface height data. The data do not
need to be detrended prior to use. Typical units = meters}

\item{Fs}{Sampling frequency of the data, in Hz.}

\item{threshold}{The minimum height necessary for a zero-crossing event to 
be considered a wave.}

\item{plot}{Set to TRUE if summary histograms of wave heights and wave
periods are desired.}
}
\value{
A list object containing summary statistic values.

\itemize{
  \item \code{Hsig} Mean of the highest 1/3 of waves in the data set. Units = 
  same as input surface heights.

  \item \code{Hmean}  Overall mean wave height, for all waves (bigger than 
  threshold). 

  \item \code{H10} Mean height of the upper 10\% of all waves. 

  \item \code{Hmax} Maximum wave height in the input data.

  \item \code{Tmean} Mean period of all waves (bigger than threshold). 
  Units = seconds.

  \item \code{Tsig} Mean period of \code{Hsig} (highest 1/3 of waves).
}
}
\description{
Calculate ocean wave summary statistics, including significant
wave height and period.
}
\details{
Based on an upward zero-crossing algorithm originally
provided by Urs Neumeier, v1.06. However, by default the algorithm
is run as a downward zero-crossing process by inverting the data.
}
\examples{
data(wavedata)
waveStatsZC(data = wavedata$swDepth.m, Fs = 4, plot = TRUE)
}
\references{
Original MATLAB function by Urs Neumeier:  
http://neumeier.perso.ch/matlab/waves.html
}
\seealso{
\code{\link{waveStatsSP}} for wave statistics determined using 
spectral analysis methods.
}
