% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_opacite_elargi.R
\name{set_opacite_elargi}
\alias{set_opacite_elargi}
\title{Modify the opacity of the expanded representation of a 'leaflet' map}
\usage{
set_opacite_elargi(map, opacite = 0.6, map_leaflet = NULL)
}
\arguments{
\item{map}{objet leaflet.}

\item{opacite}{valeur numerique (numeric). Chiffre entre 0 (transparent) et
1 (opaque). Par defaut a 0.6 (60 pour cent d'opacite ou 40 pour cent de
transparence).}

\item{map_leaflet}{objet leaflet. Pour l'integration des fonctions leaflet
dans les applications shiny (cf vignette). Par defaut a NULL.}
}
\value{
Retourne un objet leaflet.
}
\description{
Modify the opacity of the expanded representation of a 'leaflet' map for
proportional circles and chroropleth.
}
\details{
Seule la representation elargie est concernee par la modification de
l'opacite. La representation principale reste 100 pour cent opaque.
}
\examples{

data("donnees_monoloc")
data("depm")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm[depm$REG=="93",],
fondMailleElargi = depm, fondSuppl = depm, idData = "COD_DEP",
varVolume = "POP_2015")
map <- set_opacite_elargi(map = map, opacite = 0.8)
\donttest{
 map
}

}
\seealso{
\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes}, \link{leaflet_classes_ronds},
\link{leaflet_typo},}

\code{\link{leaflet_oursins}, \link{leaflet_joignantes},
\link{leaflet_saphirs}}
}
\keyword{documentation}
