% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binMean1D}
\alias{binMean1D}
\title{Bin-average f=f(x)}
\usage{
binMean1D(x, f, xbreaks, include.lowest = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{vector of numerical values that will be categorized into
bins via the \code{xbreaks} parameter.}

\item{f}{vector of numerical values that are associated with the \code{x} values.}

\item{xbreaks}{vector of values of \code{x} at the boundaries between bins, calculated using
\code{\link[=pretty]{pretty()}} if not supplied.}

\item{include.lowest}{logical value indicating whether to include
\code{x} values that equal \code{xbreaks[1]}.  See \dQuote{Details}.}

\item{na.rm}{logical value indicating whether to remove NA values before
doing the computation of the average. This is passed to \code{\link[=mean]{mean()}}, which
does the work of the present function.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks},
midpoints (\code{xmids}) between those breaks,
the count (\code{number}) of \code{x} values between successive breaks,
and the resultant average (\code{result}) of \code{f}, classified by the
\code{x} breaks.
}
\description{
Average the values of a vector \code{f} in bins defined on another
vector \code{x}. The values are broken up into bins using \code{\link[=cut]{cut()}}.
}
\details{
By default, the sub-intervals defined by the \code{xbreaks} argument are open
on the left and closed on the right, to match the behaviour
of \code{\link[=cut]{cut()}}.  An open interval does not include points on
the boundary, and so any \code{x} values that exactly match
the first \code{breaks} value will not be counted.  To include
such points in the calculation, set \code{include.lowest} to TRUE.
}
\examples{
# Plot raw temperature profile as circles, with lines indicating
# the result of averaging in 1-metre depth intervals.
library(oce)
data(ctd)
z <- ctd[["z"]]
T <- ctd[["temperature"]]
plot(T, z, cex = 0.3)
TT <- binMean1D(z, T, seq(-100, 0, 1))
lines(TT$result, TT$xmids, col = rgb(1, 0, 0, 0.9), lwd = 2)

}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binApply2D}()},
\code{\link{binAverage}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
