% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order-book-reconstruction.R
\name{orderBook}
\alias{orderBook}
\title{Instantaneous limit order book reconstruction.}
\usage{
orderBook(events, tp = as.POSIXlt(Sys.time(), tz = "UTC"),
  max.levels = NULL, bps.range = 0, min.bid = 0, max.ask = Inf)
}
\arguments{
\item{events}{Limit order \code{\link{events}} data.frame.}

\item{tp}{Time point to re-construct order book at.}

\item{max.levels}{Max number of price levels to return.}

\item{bps.range}{Max depth to return +- BPS from best bid/ask.}

\item{min.bid}{Min bid to return.}

\item{max.ask}{Max ask to return.}
}
\value{
Limit Order Book structure. A list containing 3 fields:

\describe{
  \item{timestamp}{Timestamp the order book was reconstructed for.}
  \item{asks}{A data.frame containing the Ask side of the order book.}
  \item{bids}{A data.frame containing the Bid side of the order book.}
}

The \emph{bids} and \emph{asks} data consists of the following:

\describe{
  \item{id}{Limit order Id.}
  \item{timestamp}{Last modification time to limit order.}
  \item{exchange.timestamp}{Time at which order was placed in order book.}
  \item{price}{Limit order price.}
  \item{volume}{Limit orer volume.}
  \item{liquidity}{Cumulative sum of volume from best bid/ask up until price.}
  \item{bps}{Distance (in BPS) of order from best bid/ask.}
}

Both the \emph{bids} and \emph{asks} data are ordered by descending price.
}
\description{
Given a set of \code{\link{events}}, reconstructs a limit order book for a
specific point in time.
}
\details{
An order book consists of 2 sides: \emph{bids} and \emph{asks}, an example of
which is shown below:

\tabular{rrrrrrr}{
      id \tab  price \tab     volume \tab  liquidity \tab  bps \cr
65613703 \tab 236.58 \tab  910229141 \tab 6341547077 \tab 2.11 \cr
65613655 \tab 236.56 \tab 1320000000 \tab 5431317936 \tab 1.26 \cr
65613700 \tab 236.55 \tab 1320000000 \tab 4111317936 \tab 0.84 \cr
65613698 \tab 236.54 \tab 1600000000 \tab 2791317936 \tab 0.42 \cr
65613712 \tab 236.53 \tab 1191317936 \tab 1191317936 \tab 0.00 \cr
       - \tab      - \tab          - \tab          - \tab    - \cr
65613225 \tab 236.36 \tab   16154172 \tab   16154172 \tab 0.00 \cr
65613681 \tab 236.31 \tab  200000000 \tab  216154172 \tab 2.11 \cr
65613220 \tab 236.30 \tab  100000000 \tab  316154172 \tab 2.53 \cr
65612978 \tab 236.28 \tab  100000000 \tab  416154172 \tab 3.38 \cr
65612388 \tab 236.17 \tab  100000000 \tab  516154172 \tab 8.03}
}
\examples{

tp <- as.POSIXct("2015-05-01 04:25:15.342", tz="UTC")
orderBook(lob.data$events, max.levels=5)

}
\author{
phil
}

