% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_runs.R
\name{runs_list_run_steps_request}
\alias{runs_list_run_steps_request}
\title{API runs: list run steps}
\usage{
runs_list_run_steps_request(
  thread_id,
  run_id,
  limit = NULL,
  order = NULL,
  after = NULL,
  before = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{thread_id}{string, the ID of the thread the run belongs to}

\item{run_id}{string, the ID of the run the run steps belong to}

\item{limit}{NULL/integer, a limit on the number of objects to be returned. Limit can range between 1 and 100,
and the default is 20.}

\item{order}{NULL/string, sort order by the created_at timestamp of the objects. asc for ascending order and desc for
descending order. Defaults to desc}

\item{after}{NULL/string, a cursor for use in pagination. after is an object ID that defines your place in the list.
For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
include after=obj_foo in order to fetch the next page of the list.}

\item{before}{NULL/string, a cursor for use in pagination. before is an object ID that defines your place in the
list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
include before=obj_foo in order to fetch the previous page of the list.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Returns a list of runs belonging to a thread. To get more details, visit
https://platform.openai.com/docs/api-reference/runs/listRuns
https://platform.openai.com/docs/assistants
}
