% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_images.R
\name{images_edit_request}
\alias{images_edit_request}
\title{API images: edit request}
\usage{
images_edit_request(
  image,
  prompt,
  mask = NULL,
  model = NULL,
  n = NULL,
  size = NULL,
  response_format = NULL,
  user = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{image}{string/raw, the image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not
provided, image must have transparency, which will be used as the mask.}

\item{prompt}{string, a text description of the desired image(s). The maximum length is 1000 characters.}

\item{mask}{NULL/string/raw, an additional image whose fully transparent areas (e.g. where alpha is zero) indicate
where image should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.}

\item{model}{NULL/string, the model to use for image generation. Only dall-e-2 is supported at this time.}

\item{n}{NULL/int, the number of images to generate. Must be between 1 (default) and 10.}

\item{size}{NULL/string, the size of the generated images. Must be one of 256x256, 512x512, or 1024x1024 (default).}

\item{response_format}{NULL/string, the format in which the generated images are returned. Must be one of "url" or
"b64_json".}

\item{user}{string a unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Creates an edited or extended image given an original image and a prompt. To get more details, visit
https://platform.openai.com/docs/api-reference/images/edits
}
