% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readStories.R
\name{readStories}
\alias{readStories}
\title{Initial User Story Parse}
\usage{
readStories(url)
}
\arguments{
\item{url}{The URL of the text file to be parsed. Every user story must be
in a single line, and written in English. Punctuation is irrelevant as
it is processed out.
For this to work, user stories should follow the who, what, why
template, with keywords: \code{"as a/an "}, \code{" I want to "},
\code{" so that "}, respectively.}
}
\value{
A dataframe of three colums, representing sections who, what, why
   of the user stories. There is one row per user story, and they may not
   have the "why" part if it wasn't added. Using incorrect keywords means
   incorrect parsing, so be careful.
}
\description{
This function will help you parse a set of stories into a dataframe, where
    one row is each user story; The user story gets splitted into who, what
    and why sections, according to the use of keywords. The file must be a
    text file written in English, with one user story per row.
}
\examples{
# Analyse without reports
dataPath <- example_stories()
stories <- readStories(dataPath)

# Print some information
head(dplyr::as_tibble(stories))

}
\concept{Basic Functions}
