% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_rotate_procrustes.R
\name{pca_rotate_procrustes}
\alias{pca_rotate_procrustes}
\title{Apply Procrustes rotation to PCA loadings and scores.}
\usage{
pca_rotate_procrustes(
  to_rotate,
  target,
  max_pcs,
  rotate = "loadings",
  rotation_variables = "all"
)
}
\arguments{
\item{to_rotate}{an object of class \code{princomp} or \code{prcomp}.}

\item{target}{an object of class \code{princomp} or \code{prcomp}}

\item{max_pcs}{an integer. Rotation will be applied from PC1 up to \code{max_pcs}.}

\item{rotate}{a string, either "loadings" or "scores", to identify whether
the loadings of \code{to_rotate} should be aligned with \code{target} or the scores
(default: "loadings")}

\item{rotation_variables}{a string, names of variables to be used in the
rotation. Applied to rotation of loadings when two datasets have only
partial overlap of variables. (default: "all", which uses all variables).}
}
\value{
an object matching the class of \code{to_rotate}.
}
\description{
It is sometimes convenient to rotate principal components to align PCA
applied to one dataset with PCA applied to another. This function
allows for Procrustes rotation of Principal Components, without scaling.
That is, we rotate and/or flip loadings or scores so that the PCA analyses
to be rotated most closely matches the loadings (or scores) from the target
PCA analysis.
}
\details{
\strong{NB: rotated components are not principal components.} They no longer explain
maximal variance. Rotated components should not be referred to as 'principal
components'. The simplest approach is just to call them 'components' after
describing the rotation. This function modifies objects of the class 'prcomp'
and 'princomp', adding an additional 'note' which collects all the rotations
which have been applied. This allows any plotting function which works with
the outputs of \code{prcomp()} or \code{princomp()} to work. This may result in plots
which incorrectly identify rotated components as principal components. Be
careful not to include any such plot in a research output.
}
\examples{
  # PCA on a subset of ONZE speakers
  onze_pca <- prcomp(
    onze_intercepts |> dplyr::select(-speaker),
    scale = TRUE
   )

   # PCA on all ONZE speakers
   onze_full <- prcomp(
    onze_intercepts_full |> dplyr::select(-speaker),
    scale = TRUE
   )

   # rotate subset to match loadings of `onze_full`
   rotated_pca <- onze_pca |>
     pca_rotate_procrustes(
       onze_full, max_pcs = 5
     )
}
