% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labbcatCredentials.R
\name{labbcatCredentials}
\alias{labbcatCredentials}
\title{Sets the username and password for a given LaBB-CAT server}
\usage{
labbcatCredentials(labbcat.url, username, password, auth.method = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance.}

\item{username}{The LaBB-CAT username, if it is password-protected.}

\item{password}{The LaBB-CAT password, if it is password-protected.}

\item{auth.method}{The HTTP authentication method to use (e.g. "Basic" or "Form",
or NULL to detect automatically.}
}
\value{
NULL if the username/password are correct, and a string describing the problem
if a problem occurred, e.g. "Credentials rejected" if the username/password are
incorrect, or a string starting "Version mismatch" if the server's version of
LaBB-CAT is lower than the minimum required.
}
\description{
Sets the username and password that the package should use for connecting
to a given LaBB-CAT server in future function calls.
}
\details{
If you are using R interactively, this step is optional, as all functions will prompt
the user for the username and password if required. If the script is running in
RStudio, then the RStudio password input dialog is used, hiding the credentials from view.
Otherwise, the console is used, and credentials are visible.

The recommended approach is to \strong{not} use labbcatCredentials, to avoid saving
user credentials in script files that may eventually become visible to other.
Use labbcatCredentials \strong{only} in cases where the script execution is unsupervised,
e.g. if you are executing an R script from a shell script, or using Knit to render an
Rmarkdown document.

If you must use labbcatCredentials, avoid including the actual username and password in
your script. The recommended approach is to store the username and password (and
perhaps the URL too) in your \file{.Renviron} file (in your home directory, or the
project directory), like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{LABBCAT_URL=https://labbcat.canterbury.ac.nz/demo/
LABBCAT_USERNAME=demo
LABBCAT_PASSWORD=demo
}\if{html}{\out{</div>}}

And then call Sys.getenv to retrieve the
username/password, as illustrated in the example.
}
\examples{
\dontrun{
## load the LaBB-CAT URL from .Renviron
labbcat.url <- Sys.getenv('LABBCAT_URL')

## load the username/password from .Renviron so secrets are not included in the script:
labbcatCredentials(
    labbcat.url, Sys.getenv('LABBCAT_USERNAME'), Sys.getenv('LABBCAT_PASSWORD'))
}

}
\keyword{connect}
\keyword{password}
\keyword{timeout}
\keyword{username}
