% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchingParticipantIds.R
\name{getMatchingParticipantIds}
\alias{getMatchingParticipantIds}
\title{Gets a list of IDs of participants that match a particular pattern}
\usage{
getMatchingParticipantIds(
  labbcat.url,
  expression,
  page.length = NULL,
  page.number = NULL
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{expression}{An expression that determines which participants match}

\item{page.length}{The maximum number of IDs to return, or null to return all}

\item{page.number}{The zero-based page number to return, or null to return the first page}
}
\value{
A list of paricipant IDs
}
\description{
Gets a list of IDs of participants that match a particular pattern.
}
\details{
The results can be exhaustive, by omitting page.length and
page.number, or they  can be a subset (a 'page') of results, by
given page.length and page.number values.

The expression language is currently not well defined, but is based on JavaScript
syntax.
\itemize{
\item The \emph{labels} function can be used to represent a list of all the annotation
labels on a given layer. For example, each participant can have multiple
corpora, so the corpus labels (names) are represented by:
\code{labels('corpus')}
\item Use the \emph{includes} function on a list to test whether the list contains a
given element. e.g. to match participants that include the corpus 'QB' use:
\verb{labels('corpus').includes('QB')}
\item Use the \emph{first} function to identify the first (or the only) annotation on
a given layer. e.g. the annotation representing the participant's gender is:
\code{first('participant_gender')}
\item Single annotations have various attributes, including 'id', 'label', 'ordinal', etc.
e.g. the label of the participant's gender is:
\verb{first('participant_gender').label}
\item Regular expressions can be matched by using expressions like
'/regex/.test(str)', e.g. to test if the ID starts with 'BR' use:
\verb{/^BR.+/.test(id)}
or to test if the participant's gender includes 'binary' use:
\verb{/.*binary.*/.test(first('participant_gender').label)}
}

Expressions such as those in the examples can be used.
}
\examples{
\dontrun{
## Get all participants whose IDs start with "BR"
participants <- getMatchingParticipantIds(labbcat.url, "/^BR.+/.test(id)")

## Get the first twenty transcripts in the "QB" corpus
participants <- getMatchingParticipantIds(
        labbcat.url, "labels('corpus').includes('QB')", 20, 0)

## Get all participants in the "QB" corpus that have "Jacqui" as part of the ID
participants <- getMatchingTranscriptParticipantIds(
        labbcat.url, "labels('corpus').includes('QB') && /^BR.+/.test(id)")
}

}
\keyword{expression}
\keyword{transcript}
