% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_affix.R
\name{f_affix}
\alias{f_affix}
\alias{ff_affix}
\alias{f_prefix}
\alias{ff_prefix}
\alias{f_suffix}
\alias{ff_suffix}
\title{Add String Affixes}
\usage{
f_affix(x, prefix = "", suffix = "", ...)

ff_affix(...)

f_prefix(x, prefix = "$", ...)

ff_prefix(...)

f_suffix(x, suffix = "\%", ...)

ff_suffix(...)
}
\arguments{
\item{x}{A vector of elements to append with an affix.}

\item{prefix}{A string to append to the front of elements.}

\item{suffix}{A string to append to the back of elements.}

\item{\ldots}{ignored.}
}
\value{
Returns a string of affix appended digits.
}
\description{
Convenience function to add affixes to strings (prefixes & suffixes).
}
\examples{
f_affix(1:5, "-", "\%")
f_affix(f_num(1:5, 2), "-", "\%")

f_prefix(LETTERS[1:5], "_")
f_prefix(f_bills(123456789123, -2), "$")

f_suffix(LETTERS[1:5], "_")
f_suffix(f_num(1:5, 2), "\%")

\dontrun{
f_bills(123456789123, -2) \%>\%
    f_prefix("$")
}
}
