% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-dist.r
\name{null_dist}
\alias{null_dist}
\title{Generate null data with a specific distribution.}
\usage{
null_dist(var, dist, params = NULL)
}
\arguments{
\item{var}{variable name}

\item{dist}{distribution name. One of: beta, cauchy, chisq,
exp, f, gamma, geom, lnorm, logis,
nbinom, binom, norm, pois, t, unif, weibull}

\item{params}{list of parameters of distribution. If \code{NULL}, will
use \code{\link[MASS]{fitdistr}} to estimate them.}
}
\value{
a function that given \code{data} generates a null data set.
For use with \code{\link{lineup}} or \code{\link{rorschach}}
}
\description{
Null hypothesis: variable has specified distribution
}
\examples{
dframe <- data.frame(x = rnorm(150))
library(ggplot2)
# three histograms of normally distributed values
ggplot(
  data=rorschach(method=null_dist("x", "norm"), n = 3, true=dframe)
  ) +
  geom_histogram(aes(x=x, y=..density..), binwidth=0.25) +
  facet_grid(.~.sample) +
  geom_density(aes(x=x), colour="steelblue", size=1)

# uniform distributions are not as easy to recognize as such
dframe$x = runif(150)
ggplot(
  data=rorschach(method=null_dist("x", "uniform",
                 params=list(min=0, max=1)),
  n = 3, true=dframe)) +
  geom_histogram(aes(x=x, y=..density..), binwidth=0.1) +
  facet_grid(.~.sample) +
  geom_density(aes(x=x), colour="steelblue", size=1)
}
\seealso{
null_permute, null_lm
}
